<?php

namespace App\Http\Controllers\Api\EmployeePanel;

use App\Http\Controllers\Api\ApiProjectController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Attendance\StudentAttendance;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskMenu;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskSetting;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskSettingDetail;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteAnswerPaperDistributionDetail;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Site\Role\SiteRole;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Session;
use Response;


class EmployeeExamAttendanceController extends ApiProjectController
{
    public function __construct()
    {
        $this->middleware('api.app.access');
        $this->middleware('auth:api');
        $this->middleware('academic_group_id.check');

    }

    

    public function getSiteDepartmentClassBaseExaminationList(Request $request){

        try{

        $this->validate($request, [
            'academic_version_id' => 'required',
            'academic_year_id' => 'required',
            'academic_shift_id' => 'required',
            'academic_class_id' => 'required',
        ]);

        $this->siteInfoSessionPut($request);

        $data = $request->all();

        $examinationAll = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('exam_declared_by','site')
            ->pluck('examination_id')
            ->unique();

        $getEmployeeExaminationids= SiteAnswerPaperDistributionDetail::where('user_id', Auth::id())
            ->whereIn('examination_id', $examinationAll)
            ->pluck('examination_id')->unique();

        $examinationList=Examination::whereIn('id', $getEmployeeExaminationids)
                ->select('id','examination_name','name_key')
                ->get();

        $data=[
            'examination_list'=>$examinationList,
            'mode'=>'success',
            'status'=>'200',
        ];

        return response()->json($data,200);


        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }


    
    public function getSiteExaminationBaseSubjectList(Request $request){

        try{
            
            $this->validate($request, [
                'academic_version_id' => 'required',
                'academic_year_id' => 'required',
                'academic_shift_id' => 'required',
                'academic_class_id' => 'required',
                'examination_id' => 'required',
            ]);


        $this->siteInfoSessionPut($request);

        $data = $request->all();

        $subjectList = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('exam_declared_by','site')
            ->get();

        $subject_list_array=[];

        foreach ($subjectList as $key => $value) {

            if(count($value['site_subject_group_condition_setting_ids'])>0){
                $subject_list_array[]=$value['site_subject_group_condition_setting_ids'];
            }

        }


    $collection = collect($subject_list_array);
    $collapsed = $collection->collapse();
    $subjectConditionIDs=array_unique($collapsed->pluck('id')->toArray());

    $getEmployeeSubject= SiteAnswerPaperDistributionDetail::where('academic_version_id', $request->academic_version_id)
        ->where('academic_year_id', $request->academic_year_id)
        ->where('academic_shift_id', $request->academic_shift_id)
        ->where('academic_class_id', $request->academic_class_id)
        ->where('examination_id', $request->examination_id)
        ->where('user_id', Auth::id())
        ->whereIn('site_subject_group_condition_setting_id', $subjectConditionIDs)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })
        ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
            return $query->where('academic_section_id', $data['academic_section_id']);
        })
        ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            return $query->where('academic_session_id', $data['academic_session_id']);
        })
        ->pluck('site_subject_group_condition_setting_id');


        $subjectIDs_array=SubjectGroupConditionSetting::whereIn('id', $getEmployeeSubject)
            ->select('id','academic_subject_id')
            ->get();

            $data=[
                'subject_gorup_condition_setting_list'=>$subjectIDs_array,
                'mode'=>'success',
                'status'=>'200',
            ];
    
            return response()->json($data,200);
    

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }

    public function getSiteEmployeeBaseAnswerPaperList(Request $request){

        try{

        $this->validate($request, [
            'academic_version_id' => 'required',
            'academic_year_id' => 'required',
            'academic_shift_id' => 'required',
            'academic_class_id' => 'required',
            'examination_id' => 'required',
            'site_subject_group_condition_setting_id' => 'required',
        ]);

        $this->siteInfoSessionPut($request);

        $data = $request->all();

        $getEmployeeSubject= SiteAnswerPaperDistributionDetail::with(['department', 'stClass', 'classGroup',
            'session', 'section', 'academicExamType'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->where('user_id', Auth::id())
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_section_id')
            ->orderBy('academic_session_id')
            ->get();

        $data=[
            'employee_paper_distribution_list'=>$getEmployeeSubject,
            'mode'=>'success',
            'status'=>'200',
        ];

        return response()->json($data,200);
     
    } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }



    public function getSiteStudentListForAttendanceApi(Request $request){
        try{

        $this->validate($request, [
            'site_subject_group_condition_setting_id' => 'required',
            'answer_paper_distribution_detail_id' => 'required',
        ]);


        $this->siteInfoSessionPut($request);

        $data = $request->all();

   //    dd($data);
        $getList=SiteAnswerPaperDistributionDetail::where('id', $request->answer_paper_distribution_detail_id)
            ->where('user_id', Auth::id())
            ->first();
     
        $examDeclaredList = SiteExamDeclares::where('academic_version_id', $getList->academic_version_id)
            ->where('academic_year_id', $getList->academic_year_id)
            ->where('academic_shift_id', $getList->academic_shift_id)
            ->where('academic_class_id', $getList->academic_class_id)
            ->where('examination_id', $getList->examination_id)
//            ->where('site_subject_group_condition_setting_ids', $request->site_subject_group_condition_setting_id)
            // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            //     return $query->where('academic_department_id', $data['academic_department_id']);
            // })
        //    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
        //        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        //    })
//            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
//                return $query->where('academic_section_id', $data['academic_section_id']);
//            })
            // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            //     return $query->where('academic_session_id', $data['academic_session_id']);
            // })
            ->pluck('id');
        
           // dd($examDeclaredList);
          

        $this->getMachineDataAndUpdate($request, $examDeclaredList);

        $studentIds=StudentHistory::where('academic_version_id', $getList->academic_version_id)
            ->where('academic_year_id', $getList->academic_year_id)
            ->where('academic_shift_id', $getList->academic_shift_id)
            ->where('academic_class_id', $getList->academic_class_id)
            ->when(!empty($getList['academic_department_id']), function ($query) use ($getList) {
                return $query->where('academic_department_id', $getList['academic_department_id']);
            })
            ->when(!empty($getList['academic_class_group_id']), function ($query) use ($getList) {
                return $query->where('academic_class_group_id', $getList['academic_class_group_id']);
            })
            ->when(!empty($getList['academic_section_id']), function ($query) use ($getList) {
                return $query->where('academic_section_id', $getList['academic_section_id']);
            })
            ->when(!empty($getList['academic_session_id']), function ($query) use ($getList) {
                return $query->where('academic_session_id', $getList['academic_session_id']);
            })
            ->where('student_roll_number', '>=', $getList->roll_from)
            ->where('student_roll_number', '<=', $getList->roll_to)
            ->orderBy('student_roll_number', 'asc')
            ->pluck('id');
         

            // $getEmployeeExaminationSubject= SiteAnswerPaperDistributionDetail::where('user_id', Auth::id())
            //         ->where('academic_version_id', $request->academic_version_id)
            //         ->where('academic_year_id', $request->academic_year_id)
            //         ->where('academic_shift_id', $request->academic_shift_id)
            //         ->where('academic_class_id', $request->academic_class_id)
            //         // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            //         //     return $query->where('academic_department_id', $data['academic_department_id']);
            //         // })
            //         // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            //         //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            //         // })
            //         // ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
            //         //     return $query->where('academic_section_id', $data['academic_section_id']);
            //         // })
            //         // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            //         //     return $query->where('academic_session_id', $data['academic_session_id']);
            //         // })
            //         ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)

            //         ->whereIn('site_exam_declare_id', $examDeclaredList)
            //         ->pluck('site_subject_group_condition_setting_id')
            //         ->unique();

            //         if(!count($getEmployeeExaminationSubject)>0){
            //             return Response::json(['message' => 'Select * Marked Field!', 'status'=>'411', 'mode'=>'success'], 411);

            //         }

        $declaredStudentList=SiteExamDeclareStudent::with(['siteExamDeclareStudentSubject'=>function($query) use ($getList){
            $query->where('site_subject_group_condition_setting_id', $getList->site_subject_group_condition_setting_id)
            ->where('academic_exam_type_id', $getList->academic_exam_type_id)
            ->with(['academicExamType'])
            ->select('id', 'site_subject_group_condition_setting_id', 'academic_exam_type_id', 'examination_id', 'site_exam_routine_id', 'student_history_id',
                'site_exam_declare_id', 'site_exam_declare_student_id','exam_attendance_status', 'exam_held_status',
                'attendance_submit_by', 'attendance_submit_by_machine');

        },
            'studentHistory'=>function($querys) use ($getList){
                $querys->select('id', 'user_id', 'student_roll_number');
                $querys->when(!empty($getList['academic_class_group_id']), function ($q) use ($getList) {
                    return $q->where('academic_class_group_id', $getList['academic_class_group_id']);
                });
            }
            ])
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->select('id','site_exam_declare_id','student_history_id')
            ->get();
            
        $student_array=[];
        foreach ($declaredStudentList as $key => $value) {
           
            if(count($value->siteExamDeclareStudentSubject)>0){
                $student_array[]=$value;
            }
        
        }
        
       
        $student_list=array_values(array_sort(collect($student_array), function ($value) {
            return $value['student_roll_number'];
        }));


        $getExamType=SiteExamDeclareStudentSubject::with(['academicExamType'])
           ->whereIn('site_exam_declare_id', $examDeclaredList)
           ->whereIn('student_history_id', $studentIds)
           ->where('academic_exam_type_id', $getList->academic_exam_type_id)
           ->where('site_subject_group_condition_setting_id', $getList->site_subject_group_condition_setting_id)
           ->distinct('academic_exam_type_id')
            ->select('academic_exam_type_id')
            ->get();
      //  dd($getExamType);
        

        $exam_type_arr=Array();
        $exam_type_array=[];
        foreach ($getExamType as $key => $value) {

            $selected_student_count=SiteExamDeclareStudentSubject::
                whereIn('site_exam_declare_id', $examDeclaredList)
                ->whereIn('student_history_id', $studentIds)
                ->where('site_subject_group_condition_setting_id', $getList->site_subject_group_condition_setting_id)
                ->where('academic_exam_type_id', $value->academic_exam_type_id)
                ->where('exam_attendance_status', true)
                ->count();

            $passed_student_count=SiteExamDeclareStudentSubject::
                whereIn('site_exam_declare_id', $examDeclaredList)
                ->whereIn('student_history_id', $studentIds)
                ->where('site_subject_group_condition_setting_id', $getList->site_subject_group_condition_setting_id)
                ->where('academic_exam_type_id', $value->academic_exam_type_id)
                ->where('exam_attendance_status', true)
                ->whereRaw('obtaine_marks >= pass_mark')
                ->count();

            $failed_student_count=SiteExamDeclareStudentSubject::
                whereIn('site_exam_declare_id', $examDeclaredList)
                ->whereIn('student_history_id', $studentIds)
                ->where('site_subject_group_condition_setting_id', $getList->site_subject_group_condition_setting_id)
                ->where('academic_exam_type_id', $value->academic_exam_type_id)
                ->where('exam_attendance_status', true)
                ->whereRaw('obtaine_marks < pass_mark')
                ->count();

            $exam_type_arr['selected_student_count']=$selected_student_count;
            $exam_type_arr['passed_student_count']=$passed_student_count;
            $exam_type_arr['failed_student_count']=$failed_student_count;
            $exam_type_arr['select_all']=false;


            $exam_type_array[$key]=array_merge($exam_type_arr, $value->toArray());
        }

        $data=[
            'StudentListForAttendance'=>$student_list,
            'exam_type_list'=>$exam_type_array,
            'mode'=>'success',
            'status'=>'200',
        ];
        

        return response()->json($data,200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }

    
    private function getMachineDataAndUpdate($request, $examDeclaredList){


        $exam_routine_list=SiteExamRoutine::whereIn('site_exam_declare_id', $examDeclaredList)
            ->where('exam_start_date', Carbon::today())
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->get();



        $routine_ids=$exam_routine_list->pluck('id')->unique()->filter();
        $routine_exam_start_date=$exam_routine_list->pluck('exam_start_date')->first();
        $routine_exam_end_time=$exam_routine_list->pluck('exam_end_time')->first();


        $routine_base_student_ids=SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->pluck('student_history_id')
            ->unique()
            ->values();


//        SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)->update([
//            'exam_held_status'=>false,
//            'attendance_submit_by_machine'=>false,
//            'attendance_update_at'=>null,
//            'attendance_submit_by'=>null,
//            'exam_attendance_status'=>false,
//        ]);


        $check_student_punch_status=StudentAttendance::where('present_date', $routine_exam_start_date)
            ->where('present_date', Carbon::today())
            ->whereIn('student_history_id', $routine_base_student_ids)
            ->select('id', 'student_history_id', 'late_status')
            ->first();


        if($check_student_punch_status){


            $check_exam_held_status_all_student=SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
                ->where('exam_attendance_status', true)
                ->first();

            if(!$check_exam_held_status_all_student){

                SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)->update([
                    'exam_held_status'=>true,
                ]);

            }



            $machin_student_ids=StudentAttendance::where('present_date', $routine_exam_start_date)
                ->where('present_date', Carbon::today())
                ->where('in_time', '<' ,$routine_exam_end_time)
                ->whereIn('student_history_id', $routine_base_student_ids)
                ->pluck('student_history_id')
                ->unique()
                ->filter();


            SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
                ->whereIn('student_history_id', $machin_student_ids)
                ->where('exam_attendance_status', false)
                ->where('attendance_submit_by', null)
                ->update([
                    'exam_held_status'=>true,
                    'exam_attendance_status'=>true,
                    'attendance_submit_by_machine'=>true,
                    'attendance_update_at'=>Carbon::now(),
                ]);


        }

    }

    public function siteStudentExamAttendanceSubmit(Request $request){

       try{

        $this->validate($request, [
            'StudentListForAttendance' => 'required',
            'site_subject_group_condition_setting_id' => 'required',
            'answer_paper_distribution_detail_id' => 'required',
        ]);


        $this->siteInfoSessionPut($request);

        $exam_type_array=[];
        foreach ($request->StudentListForAttendance as $key => $value) {

            foreach ($value['site_exam_declare_student_subject'] as $keys => $values) {
                    $exam_type_array[]=$values;
            }

        }


        $exam_type_Ids=collect($exam_type_array)->pluck('academic_exam_type_id')->unique()->filter();

        $exam_heald_exam_type=[];
        foreach ($exam_type_Ids as $key => $value) {

            $check_exam_heald= collect($exam_type_array)
                ->where('academic_exam_type_id', $value)
                ->where('exam_attendance_status', true)
                ->first();

            if($check_exam_heald){

                $exam_heald_exam_type[]=$check_exam_heald;
            }

        }

        foreach ($request->StudentListForAttendance as $key => $value) {


            foreach ($value['site_exam_declare_student_subject'] as $keys => $values) {
              
                $checkDistribution=SiteAnswerPaperDistributionDetail::where('id', $request->answer_paper_distribution_detail_id)
                    ->where('user_id', Auth::id())
                    ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
                    ->where('site_exam_declare_id', $values['site_exam_declare_id'])
                    ->first();

                    if ($checkDistribution) {
                        $checkStudent=StudentHistory::where('id', $values['student_history_id'])
                            ->where('student_roll_number', '>=', $checkDistribution->roll_from)
                            ->where('student_roll_number', '<=', $checkDistribution->roll_to)
                            ->first();

                        if($checkStudent){
                            $check_data=collect($exam_heald_exam_type)->where('academic_exam_type_id', $values['academic_exam_type_id'])->first();

                            if($check_data){
                                $exam_held_status=true;
                            }else{
                                $exam_held_status=false;
                            }
                            
            
                            $exam_attendance_status= $values['exam_attendance_status'];
            
                            SiteExamDeclareStudentSubject::where('id', $values['id'])
                                ->where('student_history_id', $checkStudent->id)
                                ->update([
                                    'exam_attendance_status'=>$exam_attendance_status,
                                    'exam_held_status'=>$exam_held_status,
                                    'attendance_update_at'=>Carbon::now(),
                                    'attendance_submit_by'=> Auth::user()->id,
                                ]);
            
                        }
                    }
              
            }

        }

        return Response::json(['message' => 'Attendance Entry Successfully!', 'status'=>'200', 'mode' => 'Success'], 200);

    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }

    }


   
}
